import os
import sys

PARENT_DIR = os.path.abspath(os.path.join(os.path.dirname(__file__), "../"))
sys.path.append(PARENT_DIR)
sys.path.append(PARENT_DIR + "/model")
sys.path.append(PARENT_DIR + "/config")
sys.path.append(PARENT_DIR + "/tools")

def load_config_from_file(file_path):
    config = {}
    try:
        with open(file_path, 'r') as file:
            # Read and execute the file's content
            code = file.read()
            exec(code, {}, config)

        # Filter out any built-in variables or functions added by exec
        config = {key: value for key, value in config.items() if not key.startswith('__')}
    except Exception as e:
        print(f"Error loading config from file: {e}")
        return {}

    return config

if __name__ == "__main__":

    file_path = "../config/lstm.py"  # Replace with the actual path
    config = load_config_from_file(file_path)
    print(config)